/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.undertaker;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.GraveData;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.tileentities.TileEntityGrave;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.api.util.constant.UndertakerConstants;
import com.minecolonies.coremod.colony.buildings.modules.GraveyardManagementModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingGraveyard;
import com.minecolonies.coremod.colony.jobs.JobUndertaker;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.util.AdvancementUtils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkUndertaker
extends AbstractEntityAIInteract<JobUndertaker, BuildingGraveyard> {
    private Random random = new Random();
    private int effortCounter = 0;
    private boolean shouldDumpInventory = false;
    private BlockPos wanderPos = null;
    private Tuple<BlockPos, Direction> burialPos = null;

    public EntityAIWorkUndertaker(@NotNull JobUndertaker job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 60), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorking, 5), new AITarget((IAIState)AIWorkerState.WANDER, this::wander, 5), new AITarget((IAIState)AIWorkerState.EMPTY_GRAVE, this::emptyGrave, 5), new AITarget((IAIState)AIWorkerState.TRY_RESURRECT, this::tryResurrect, 5), new AITarget((IAIState)AIWorkerState.DIG_GRAVE, this::digGrave, 5), new AITarget((IAIState)AIWorkerState.BURY_CITIZEN, this::buryCitizen, 5));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingGraveyard> getExpectedBuildingClass() {
        return BuildingGraveyard.class;
    }

    @NotNull
    private IAIState startWorking() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        this.worker.getCitizenData().setIdleAtJob(false);
        @Nullable BlockPos currentGrave = ((BuildingGraveyard)this.building).getGraveToWorkOn();
        if (currentGrave != null) {
            if (this.walkToBuilding()) {
                return this.getState();
            }
            BlockEntity entity = this.world.m_7702_(currentGrave);
            if (entity instanceof TileEntityGrave) {
                ((BuildingGraveyard)this.building).getFirstModuleOccurance(GraveyardManagementModule.class).setLastGraveData((GraveData)((TileEntityGrave)entity).getGraveData());
                return AIWorkerState.EMPTY_GRAVE;
            }
            ((BuildingGraveyard)this.building).ClearCurrentGrave();
        }
        return AIWorkerState.WANDER;
    }

    @NotNull
    private IAIState wander() {
        if (this.worker.getNavigation().m_26571_()) {
            if (((BuildingGraveyard)this.building).isInBuilding(this.worker.m_142538_())) {
                this.worker.getNavigation().moveToRandomPos(10, 0.6, ((BuildingGraveyard)this.building).getCorners(), AbstractAdvancedPathNavigate.RestrictionType.XYZ);
            } else {
                this.walkToBuilding();
            }
        }
        return AIWorkerState.IDLE;
    }

    private IAIState emptyGrave() {
        @Nullable BuildingGraveyard buildingGraveyard = (BuildingGraveyard)this.building;
        if (buildingGraveyard == null || this.checkForToolOrWeapon(ToolType.SHOVEL) || buildingGraveyard.getGraveToWorkOn() == null) {
            return AIWorkerState.IDLE;
        }
        this.worker.getCitizenData().setVisibleStatus(UndertakerConstants.EMPTYING_ICON);
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{new TranslatableComponent("com.minecolonies.gui.visiblestatus.emptying")});
        this.worker.m_6858_(this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.UNDERTAKER_RUN) > 0.0);
        this.unequip();
        @Nullable BlockPos gravePos = buildingGraveyard.getGraveToWorkOn();
        if (this.walkToBlock(gravePos, 3)) {
            return this.getState();
        }
        BlockEntity entity = this.world.m_7702_(gravePos);
        if (entity instanceof TileEntityGrave) {
            if (((TileEntityGrave)entity).isEmpty()) {
                return AIWorkerState.TRY_RESURRECT;
            }
            if (this.worker.getInventoryCitizen().isFull()) {
                return AIWorkerState.INVENTORY_FULL;
            }
            if (this.effortCounter < 100) {
                this.worker.m_6674_(InteractionHand.MAIN_HAND);
                this.effortCounter += this.getPrimarySkillLevel();
                return this.getState();
            }
            this.effortCounter = 0;
            if (InventoryUtils.transferAllItemHandler((IItemHandler)((TileEntityGrave)entity).getInventory(), (IItemHandler)this.worker.getInventoryCitizen())) {
                return AIWorkerState.TRY_RESURRECT;
            }
        }
        return AIWorkerState.IDLE;
    }

    private IAIState digGrave() {
        @Nullable BuildingGraveyard buildingGraveyard = (BuildingGraveyard)this.building;
        if (this.checkForToolOrWeapon(ToolType.SHOVEL) || buildingGraveyard.getGraveToWorkOn() == null) {
            return AIWorkerState.IDLE;
        }
        this.worker.getCitizenData().setVisibleStatus(UndertakerConstants.DIGGING_ICON);
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{new TranslatableComponent("com.minecolonies.gui.visiblestatus.digging")});
        this.worker.m_6858_(this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.UNDERTAKER_RUN) > 0.0);
        @Nullable BlockPos gravePos = buildingGraveyard.getGraveToWorkOn();
        if (gravePos == null) {
            return AIWorkerState.IDLE;
        }
        if (this.walkToBlock(gravePos, 3)) {
            return this.getState();
        }
        this.worker.m_6858_(false);
        BlockEntity entity = this.world.m_7702_(gravePos);
        if (entity instanceof TileEntityGrave) {
            if (!this.digIfAble(gravePos)) {
                return this.getState();
            }
            this.worker.decreaseSaturationForAction();
            this.worker.getCitizenData().getCitizenSkillHandler().addXpToSkill(this.getModuleForJob().getPrimarySkill(), 7.5, this.worker.getCitizenData());
            return AIWorkerState.BURY_CITIZEN;
        }
        return AIWorkerState.IDLE;
    }

    private boolean digIfAble(BlockPos position) {
        if (!this.checkForToolOrWeapon(ToolType.SHOVEL)) {
            this.equipShovel();
            this.worker.m_6674_(this.worker.m_7655_());
            if (this.mineBlock(position)) {
                this.world.m_46597_(position, Blocks.f_50016_.m_49966_());
                this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
                this.worker.decreaseSaturationForContinuousAction();
                ((BuildingGraveyard)this.building).ClearCurrentGrave();
                return true;
            }
        }
        return false;
    }

    private IAIState tryResurrect() {
        @Nullable BuildingGraveyard buildingGraveyard = (BuildingGraveyard)this.building;
        if (this.checkForToolOrWeapon(ToolType.SHOVEL) || buildingGraveyard.getFirstModuleOccurance(GraveyardManagementModule.class).getLastGraveData() == null || buildingGraveyard.getGraveToWorkOn() == null) {
            return AIWorkerState.IDLE;
        }
        this.unequip();
        @Nullable BlockPos gravePos = buildingGraveyard.getGraveToWorkOn();
        if (gravePos == null) {
            return AIWorkerState.IDLE;
        }
        if (this.walkToBlock(gravePos, 3)) {
            return this.getState();
        }
        BlockEntity entity = this.world.m_7702_(gravePos);
        if (entity instanceof TileEntityGrave) {
            if (this.effortCounter < 400) {
                this.worker.m_6674_(InteractionHand.MAIN_HAND);
                this.effortCounter += this.getSecondarySkillLevel();
                return this.getState();
            }
            this.effortCounter = 0;
            this.shouldDumpInventory = true;
            double chance = this.getResurrectChance(buildingGraveyard);
            if (this.getTotemResurrectChance() > 0.0 && this.random.nextDouble() <= 0.01) {
                this.worker.getInventoryCitizen().extractItem(InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), Items.f_42747_), 1, false);
                this.worker.m_5496_(SoundEvents.f_12513_, 1.0f, 1.0f);
            }
            if (chance >= this.random.nextDouble()) {
                ICitizenData citizenData = buildingGraveyard.getColony().getCitizenManager().resurrectCivilianData(buildingGraveyard.getFirstModuleOccurance(GraveyardManagementModule.class).getLastGraveData().getCitizenDataNBT(), true, this.world, gravePos);
                MessageUtils.format("com.minecolonies.coremod.resurrect", citizenData.getName()).sendTo(buildingGraveyard.getColony()).forManagers();
                this.worker.getCitizenColonyHandler().getColony().getCitizenManager().updateCitizenMourn(citizenData, false);
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.worker.getCitizenColonyHandler().getColony(), playerMP -> AdvancementTriggers.CITIZEN_RESURRECT.trigger((ServerPlayer)playerMP));
                buildingGraveyard.getFirstModuleOccurance(GraveyardManagementModule.class).setLastGraveData(null);
                this.world.m_46597_(gravePos, Blocks.f_50016_.m_49966_());
                return AIWorkerState.INVENTORY_FULL;
            }
        }
        return AIWorkerState.DIG_GRAVE;
    }

    private double getResurrectChance(@NotNull BuildingGraveyard buildingGraveyard) {
        double cap;
        double totemChance = this.getTotemResurrectChance();
        double chance = (double)buildingGraveyard.getBuildingLevel() * 0.005 + (double)this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Mana) * 0.00125 + this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RESURRECT_CHANCE) + totemChance;
        if (chance > (cap = 0.025 + (double)this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getMysticalSiteMaxBuildingLevel() * 0.005 + totemChance)) {
            chance = cap;
        }
        return chance;
    }

    private double getTotemResurrectChance() {
        int totems = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.f_42747_);
        if (totems > 0) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(this.worker.getCitizenColonyHandler().getColony(), playerMP -> AdvancementTriggers.UNDERTAKER_TOTEM.trigger((ServerPlayer)playerMP));
        }
        if (this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.USE_TOTEM) > 0.0) {
            if (totems == 1) {
                return 0.05;
            }
            if (totems > 1) {
                return 0.075;
            }
        }
        return 0.0;
    }

    private IAIState buryCitizen() {
        @Nullable BuildingGraveyard buildingGraveyard = (BuildingGraveyard)this.building;
        GraveyardManagementModule module = buildingGraveyard.getFirstModuleOccurance(GraveyardManagementModule.class);
        if (this.checkForToolOrWeapon(ToolType.SHOVEL) || module.getLastGraveData() == null) {
            return AIWorkerState.IDLE;
        }
        this.worker.getCitizenData().setVisibleStatus(UndertakerConstants.BURYING_ICON);
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{new TranslatableComponent("com.minecolonies.coremod.status.burying")});
        if (this.burialPos == null || !this.world.m_8055_(this.burialPos.getA()).m_60795_()) {
            this.burialPos = ((BuildingGraveyard)this.building).getRandomFreeVisualGravePos();
        }
        if (this.burialPos == null || this.burialPos.getA() == null) {
            this.worker.getCitizenChatHandler().sendLocalizedChat((Component)new TranslatableComponent("com.minecolonies.coremod.nospaceforgrave", new Object[]{module.getLastGraveData().getCitizenName()}));
            return AIWorkerState.IDLE;
        }
        if (this.walkToBlock(this.burialPos.getA(), 3)) {
            return this.getState();
        }
        if (this.effortCounter < 400) {
            this.equipShovel();
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            this.effortCounter += this.getPrimarySkillLevel();
            return this.getState();
        }
        this.effortCounter = 0;
        this.unequip();
        module.buryCitizenHere(this.burialPos);
        AdvancementUtils.TriggerAdvancementPlayersForColony(this.worker.getCitizenColonyHandler().getColony(), playerMP -> AdvancementTriggers.CITIZEN_BURY.trigger((ServerPlayer)playerMP));
        module.setLastGraveData(null);
        this.burialPos = null;
        this.shouldDumpInventory = true;
        return AIWorkerState.INVENTORY_FULL;
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory) {
            this.shouldDumpInventory = false;
            return true;
        }
        return false;
    }

    private void equipShovel() {
        this.worker.getCitizenItemHandler().setHeldItem(InteractionHand.MAIN_HAND, this.getShovelSlot());
    }

    private void unequip() {
        this.worker.getCitizenItemHandler().removeHeldItem();
    }

    private int getShovelSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.SHOVEL, 0, ((BuildingGraveyard)this.building).getMaxToolLevel());
    }

    @Nullable
    public AbstractEntityCitizen getCitizen() {
        return this.worker;
    }
}

